<?php
namespace Tidybot;

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Updates {
	private const DEFAULT_PLUGIN_UPDATE_URI = 'https://thevikingcoaching.com/wp-content/downloads/tidybotC.json';

	public function __construct() {
		$this->updates();
	}

	private function get_plugin_update_uri( string $default = self::DEFAULT_PLUGIN_UPDATE_URI ): string {
		// Hier kan je logica toevoegen als je in de toekomst dynamisch andere URIs wilt gebruiken
		return $default;
	}

	public function updates(): void {
		$plugin_updater_uri = $this->get_plugin_update_uri();

		if ( class_exists( PucFactory::class ) ) {
			$update_checker = PucFactory::buildUpdateChecker(
				$plugin_updater_uri,
				dirname(__FILE__, 2) . '/tidybot.php', // Pad naar het hoofdpluginbestand
				'tidybot' // Slug van de plugin
			);
		}
	}
}
