jQuery(document).ready(function($) {
    const chatWidget = $('#tidybot-chat');
    const position = chatWidget.data('position');
    
    // Enhanced debug logging
    console.log('Chat widget debug info:', {
        found: chatWidget.length > 0,
        classes: chatWidget.attr('class'),
        position: position,
        content: chatWidget.html(),
        isActive: chatWidget.hasClass('active'),
        isInactive: chatWidget.hasClass('inactive')
    });
    
    // Create toggle button if it doesn't exist
    if (!$('#tidybot-toggle').length) {
        const toggleButton = $('<div id="tidybot-toggle"><img src="' + tidybotData.pluginUrl + 'toggle-icon.png" alt="Chat" /></div>');
        chatWidget.after(toggleButton);
    }

    // Initialize TidyCal embed if it exists
    if (chatWidget.find('.tidycal-embed').length > 0) {
        // TidyCal script will handle the initialization
        console.log('TidyCal embed found and initialized');
    }

    // Toggle chat visibility
    $('#tidybot-toggle').on('click', function() {
        chatWidget.toggleClass('hidden');
    });
});
